class CTF_StatsMutator expands Mutator config(CTF_DB);

var bool bAlreadyUpdated;

var config string 	ID[10000];
var config string	Name[10000];
var config int 		Score[10000];
var config int 		Deaths[10000];
var config int 		Games[10000];
var config int		Caps[10000];
var config int		CarrierKills[10000];
var config int		Grabs[10000];

var config string 	topID[20];
var config string	topName[20];
var config int 		topScore[20];
var config int 		topDeaths[20];
var config int 		topGames[20];
var config int		topCaps[20];//topCaps[20];
var config int		topCarrierKills[20];
var config int		topGrabs[20];

function PreBeginPlay ()
{
	Super.PreBeginPlay();
	SetTimer(1.0,True);
	SaveConfig();
}

function bool HandleEndGame()
{
local Pawn P;
local Inventory Inv;

	Super.HandleEndGame();

	if (!bAlreadyUpdated)
		{
		for (P = Level.PawnList; P != None; P = P.NextPawn)
			{
			if ( P.IsA('PlayerPawn') )
				{
				for( Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory )
					{ 
					if ( Inv.IsA('CTF_item') )
						{
						if ( CTF_item(Inv).bHasFlag )
							{
							PRI(PlayerPawn(P).PlayerReplicationInfo).Caps++;
							}
						}
					}
				}
			}
		UpdateDB();
		FindTopPlayers();
		SaveConfig();
		for (P = Level.PawnList; P != None; P = P.NextPawn)
			{
			if ( P.IsA('PlayerPawn') )
				{
				for( Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory )
					{ 
					if ( Inv.IsA('CTF_item') )
						{
						if ( CTF_item(Inv).bHasFlag )
							{
							PRI(PlayerPawn(P).PlayerReplicationInfo).Caps--;
							}
						}
					}
				}
			}
		}
	bAlreadyUpdated = True;
	if (NextMutator != None)
		return (NextMutator.HandleEndGame());
}

function Timer()
{

	TopToPRI();
}


function bool AlwaysKeep(Actor Other) 
{	
	if (Other.IsA('PlayerPawn'))
        	{
		PlayerPawn(Other).PlayerReplicationInfoClass = class'PRI';
		return true;
		}

	if (NextMutator != None)
		return (NextMutator.AlwaysKeep(Other));	
	return false;
}

function ModifyPlayer(Pawn Other)
{
local Inventory Inv;
local TournamentGameReplicationInfo OwnerGame;
local TeamInfo TI;
local int TeamScore;

	if ( Other.IsA('PlayerPawn') )
		{
		// Get team score
		OwnerGame = TournamentGameReplicationInfo(PlayerPawn(Other).GameReplicationInfo);
		TI = OwnerGame.Teams[PlayerPawn(Other).PlayerReplicationInfo.Team];
		TeamScore = TI.Score;
		}
     	inv = Spawn(class'CTF_item');
	if( inv != None )
        	{
                inv.GiveTo(Other);
		CTF_item(inv).bGrabbed = False;
		CTF_item(inv).bHasFlag = False;
		CTF_item(inv).OldTeamScore = TeamScore;
                CTF_item(inv).gogo();
                }
   
     if ( NextMutator != None )
          NextMutator.ModifyPlayer(Other);
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
local Decoration Flag;
local Inventory Inv;

	if ( Killer.IsA('PlayerPawn') && damageType == 'Decapitated' && Killer != Killed )
		{
		PRI(PlayerPawn(Killer).PlayerReplicationInfo).Headshots++;
		}

	Flag = Killed.PlayerReplicationInfo.HasFlag;
	if ( Flag != None && Killer.IsA('PlayerPawn') )
		{
		PRI(PlayerPawn(Killer).PlayerReplicationInfo).CarrierKills++;
		}
	for( Inv=Killed.Inventory; Inv!=None; Inv=Inv.Inventory )
		{ 
		Inv.Destroy();
		}

	Super.PreventDeath(Killed,Killer,damageType,HitLocation);

	if ( NextMutator != None )
		{
		NextMutator.PreventDeath(Killer, Killed, damageType, HitLocation);
		}
}

function UpdateDB()
{
local string KeyName,IDp,Value,NewValue;
local int Num, i;
local Pawn P;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn') )
			{
			//Cycle database and assign new values:
			for (i=0;i<10000;i++)
				{
				if ( P.PlayerReplicationInfo.PlayerName == ID[i] || ID[i] == "" )
					{
					ID[i] = P.PlayerReplicationInfo.PlayerName;
					Score[i] += P.PlayerReplicationInfo.Score;
					Deaths[i] += P.PlayerReplicationInfo.Deaths;
					Games[i]++;
					Name[i] = P.PlayerReplicationInfo.PlayerName;
					Caps[i] += PRI(PlayerPawn(P).PlayerReplicationInfo).Caps;
					CarrierKills[i] += PRI(PlayerPawn(P).PlayerReplicationInfo).CarrierKills;
					Grabs[i] += PRI(PlayerPawn(P).PlayerReplicationInfo).Grabs;
					i = 50000;
					}
				}
			}
		}
}

function TopToPRI()
{
local Pawn P;
local int i;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn') )
			{
			//#1
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player1 = topName[0];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score1 = topScore[0];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths1 = topDeaths[0];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games1 = topGames[0];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps1 = topCaps[0];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills1 = topCarrierKills[0];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs1 = topGrabs[0];
			//#2
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player2 = topName[1];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score2 = topScore[1];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths2 = topDeaths[1];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games2 = topGames[1];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps2 = topCaps[1];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills2 = topCarrierKills[1];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs2 = topGrabs[1];
			//#3
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player3 = topName[2];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score3 = topScore[2];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths3 = topDeaths[2];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games3 = topGames[2];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps3 = topCaps[2];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills3 = topCarrierKills[2];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs3 = topGrabs[2];
			//#4
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player4 = topName[3];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score4 = topScore[3];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths4 = topDeaths[3];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games4 = topGames[3];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps4 = topCaps[3];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills4 = topCarrierKills[3];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs4 = topGrabs[3];
			//#5
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player5 = topName[4];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score5 = topScore[4];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths5 = topDeaths[4];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games5 = topGames[4];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps5 = topCaps[4];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills5 = topCarrierKills[4];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs5 = topGrabs[4];
			//#6
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player6 = topName[5];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score6 = topScore[5];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths6 = topDeaths[5];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games6 = topGames[5];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps6 = topCaps[5];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills6 = topCarrierKills[5];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs6 = topGrabs[5];
			//#7
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player7 = topName[6];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score7 = topScore[6];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths7 = topDeaths[6];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games7 = topGames[6];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps7 = topCaps[6];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills7 = topCarrierKills[6];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs7 = topGrabs[6];
			//#8
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player8 = topName[7];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score8 = topScore[7];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths8 = topDeaths[7];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games8 = topGames[7];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps8 = topCaps[7];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills8 = topCarrierKills[7];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs8 = topGrabs[7];
			//#9
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player9 = topName[8];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score9 = topScore[8];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths9 = topDeaths[8];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games9 = topGames[8];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps9 = topCaps[8];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills9 = topCarrierKills[8];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs9 = topGrabs[8];
			//#10
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player10 = topName[9];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score10 = topScore[9];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths10 = topDeaths[9];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games10 = topGames[9];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps10 = topCaps[9];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills10 = topCarrierKills[9];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs10 = topGrabs[9];
			//#11
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player11 = topName[10];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score11 = topScore[10];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths11 = topDeaths[10];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games11 = topGames[10];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps11 = topCaps[10];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills11 = topCarrierKills[10];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs11 = topGrabs[10];
			//#12
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player12 = topName[11];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score12 = topScore[11];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths12 = topDeaths[11];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games12 = topGames[11];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps12 = topCaps[11];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills12 = topCarrierKills[11];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs12 = topGrabs[11];
			//#13
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player13 = topName[12];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score13 = topScore[12];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths13 = topDeaths[12];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games13 = topGames[12];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps13 = topCaps[12];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills13 = topCarrierKills[12];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs13 = topGrabs[12];
			//#14
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player14 = topName[13];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score14 = topScore[13];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths14 = topDeaths[13];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games14 = topGames[13];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps14 = topCaps[13];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills14 = topCarrierKills[13];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs14 = topGrabs[13];
			//#15
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player15 = topName[14];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score15 = topScore[14];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths15 = topDeaths[14];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games15 = topGames[14];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps15 = topCaps[14];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills15 = topCarrierKills[14];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs15 = topGrabs[14];
			//#16
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player16 = topName[15];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score16 = topScore[15];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths16 = topDeaths[15];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games16 = topGames[15];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps16 = topCaps[15];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills16 = topCarrierKills[15];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs16 = topGrabs[15];
			//#17
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player17 = topName[16];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score17 = topScore[16];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths17 = topDeaths[16];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games17 = topGames[16];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps17 = topCaps[16];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills17 = topCarrierKills[16];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs17 = topGrabs[16];
			//#18
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player18 = topName[17];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score18 = topScore[17];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths18 = topDeaths[17];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games18 = topGames[17];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps18 = topCaps[17];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills18 = topCarrierKills[17];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs18 = topGrabs[17];
			//#19
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player19 = topName[18];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score19 = topScore[18];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths19 = topDeaths[18];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games19 = topGames[18];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps19 = topCaps[18];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills19 = topCarrierKills[18];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs19 = topGrabs[18];
			//#20
			PRI(PlayerPawn(P).PlayerReplicationInfo).Player20 = topName[19];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Score20 = topScore[19];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Deaths20 = topDeaths[19];
			PRI(PlayerPawn(P).PlayerReplicationInfo).Games20 = topGames[19];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCaps20 = topCaps[19];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topCarrierKills20 = topCarrierKills[19];
			PRI(PlayerPawn(P).PlayerReplicationInfo).topGrabs20 = topGrabs[19];
			}
		}
}

function FindTopPlayers()
{
local int i;

	//#1
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[0] )
			{
			topID[0] = ID[i];
			topScore[0] = Score[i];
			topDeaths[0] = Deaths[i];
			topGames[0] = Games[i];
			topName[0] = Name[i];
			topCaps[0] = Caps[i];
			topCarrierKills[0] = CarrierKills[i];
			topGrabs[0] = Grabs[i];
			}
		}
	//#2
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[1] && ID[i] != topID[0] )
			{
			topID[1] = ID[i];
			topScore[1] = Score[i];
			topDeaths[1] = Deaths[i];
			topGames[1] = Games[i];
			topName[1] = Name[i];
			topCaps[1] = Caps[i];
			topCarrierKills[1] = CarrierKills[i];
			topGrabs[1] = Grabs[i];
			}
		}
	//#3
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[2] && ID[i] != topID[0] && ID[i] != topID[1] )
			{
			topID[2] = ID[i];
			topScore[2] = Score[i];
			topDeaths[2] = Deaths[i];
			topGames[2] = Games[i];
			topName[2] = Name[i];
			topCaps[2] = Caps[i];
			topCarrierKills[2] = CarrierKills[i];
			topGrabs[2] = Grabs[i];
			}
		}
	//#4
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[3] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] )
			{
			topID[3] = ID[i];
			topScore[3] = Score[i];
			topDeaths[3] = Deaths[i];
			topGames[3] = Games[i];
			topName[3] = Name[i];
			topCaps[3] = Caps[i];
			topCarrierKills[3] = CarrierKills[i];
			topGrabs[3] = Grabs[i];
			}
		}
	//#5
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[4] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] )
			{
			topID[4] = ID[i];
			topScore[4] = Score[i];
			topDeaths[4] = Deaths[i];
			topGames[4] = Games[i];
			topName[4] = Name[i];
			topCaps[4] = Caps[i];
			topCarrierKills[4] = CarrierKills[i];
			topGrabs[4] = Grabs[i];
			}
		}
	//#6
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[5] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] && ID[i] != topID[4] )
			{
			topID[5] = ID[i];
			topScore[5] = Score[i];
			topDeaths[5] = Deaths[i];
			topGames[5] = Games[i];
			topName[5] = Name[i];
			topCaps[5] = Caps[i];
			topCarrierKills[5] = CarrierKills[i];
			topGrabs[5] = Grabs[i];
			}
		}
	//#7
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[6] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] && ID[i] != topID[4] && ID[i] != topID[5] )
			{
			topID[6] = ID[i];
			topScore[6] = Score[i];
			topDeaths[6] = Deaths[i];
			topGames[6] = Games[i];
			topName[6] = Name[i];
			topCaps[6] = Caps[i];
			topCarrierKills[6] = CarrierKills[i];
			topGrabs[6] = Grabs[i];
			}
		}
	//#8
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[7] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] && ID[i] != topID[4] && ID[i] != topID[5] && ID[i] != topID[6] )
			{
			topID[7] = ID[i];
			topScore[7] = Score[i];
			topDeaths[7] = Deaths[i];
			topGames[7] = Games[i];
			topName[7] = Name[i];
			topCaps[7] = Caps[i];
			topCarrierKills[7] = CarrierKills[i];
			topGrabs[7] = Grabs[i];
			}
		}
	//#9
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[8] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] && ID[i] != topID[4] && ID[i] != topID[5] && ID[i] != topID[6] && ID[i] != topID[7] )
			{
			topID[8] = ID[i];
			topScore[8] = Score[i];
			topDeaths[8] = Deaths[i];
			topGames[8] = Games[i];
			topName[8] = Name[i];
			topCaps[8] = Caps[i];
			topCarrierKills[8] = CarrierKills[i];
			topGrabs[8] = Grabs[i];
			}
		}
	//#10
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[9] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] && ID[i] != topID[4] && ID[i] != topID[5] && ID[i] != topID[6] && ID[i] != topID[7] && ID[i] != topID[8] )
			{
			topID[9] = ID[i];
			topScore[9] = Score[i];
			topDeaths[9] = Deaths[i];
			topGames[9] = Games[i];
			topName[9] = Name[i];
			topCaps[9] = Caps[i];
			topCarrierKills[9] = CarrierKills[i];
			topGrabs[9] = Grabs[i];
			}
		}
	//#11
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[10] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] && ID[i] != topID[4] && ID[i] != topID[5] && ID[i] != topID[6] && ID[i] != topID[7] && ID[i] != topID[8]
			&& ID[i] != topID[9] )
			{
			topID[10] = ID[i];
			topScore[10] = Score[i];
			topDeaths[10] = Deaths[i];
			topGames[10] = Games[i];
			topName[10] = Name[i];
			topCaps[10] = Caps[i];
			topCarrierKills[10] = CarrierKills[i];
			topGrabs[10] = Grabs[i];
			}
		}		
	//#12
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[11] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] && ID[i] != topID[4] && ID[i] != topID[5] && ID[i] != topID[6] && ID[i] != topID[7] && ID[i] != topID[8]
			&& ID[i] != topID[9] && ID[i] != topID[10] )
			{
			topID[11] = ID[i];
			topScore[11] = Score[i];
			topDeaths[11] = Deaths[i];
			topGames[11] = Games[i];
			topName[11] = Name[i];
			topCaps[11] = Caps[i];
			topCarrierKills[11] = CarrierKills[i];
			topGrabs[11] = Grabs[i];
			}
		}
	//#13
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[12] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] && ID[i] != topID[4] && ID[i] != topID[5] && ID[i] != topID[6] && ID[i] != topID[7] && ID[i] != topID[8]
			&& ID[i] != topID[9] && ID[i] != topID[10] && ID[i] != topID[11] )
			{
			topID[12] = ID[i];
			topScore[12] = Score[i];
			topDeaths[12] = Deaths[i];
			topGames[12] = Games[i];
			topName[12] = Name[i];
			topCaps[12] = Caps[i];
			topCarrierKills[12] = CarrierKills[i];
			topGrabs[12] = Grabs[i];
			}
		}
	//#14
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[13] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] && ID[i] != topID[4] && ID[i] != topID[5] && ID[i] != topID[6] && ID[i] != topID[7] && ID[i] != topID[8]
			&& ID[i] != topID[9] && ID[i] != topID[10] && ID[i] != topID[11] && ID[i] != topID[12] )
			{
			topID[13] = ID[i];
			topScore[13] = Score[i];
			topDeaths[13] = Deaths[i];
			topGames[13] = Games[i];
			topName[13] = Name[i];
			topCaps[13] = Caps[i];
			topCarrierKills[13] = CarrierKills[i];
			topGrabs[13] = Grabs[i];
			}
		}
	//#15
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[14] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] && ID[i] != topID[4] && ID[i] != topID[5] && ID[i] != topID[6] && ID[i] != topID[7] && ID[i] != topID[8]
			&& ID[i] != topID[9] && ID[i] != topID[10] && ID[i] != topID[11] && ID[i] != topID[12] && ID[i] != topID[13] )
			{
			topID[14] = ID[i];
			topScore[14] = Score[i];
			topDeaths[14] = Deaths[i];
			topGames[14] = Games[i];
			topName[14] = Name[i];
			topCaps[14] = Caps[i];
			topCarrierKills[14] = CarrierKills[i];
			topGrabs[14] = Grabs[i];
			}
		}
	//#16
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[15] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] && ID[i] != topID[4] && ID[i] != topID[5] && ID[i] != topID[6] && ID[i] != topID[7] && ID[i] != topID[8]
			&& ID[i] != topID[9] && ID[i] != topID[10] && ID[i] != topID[11] && ID[i] != topID[12] && ID[i] != topID[13] && ID[i] != topID[14] )
			{
			topID[15] = ID[i];
			topScore[15] = Score[i];
			topDeaths[15] = Deaths[i];
			topGames[15] = Games[i];
			topName[15] = Name[i];
			topCaps[15] = Caps[i];
			topCarrierKills[15] = CarrierKills[i];
			topGrabs[15] = Grabs[i];
			}
		}
	//#17
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[16] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] && ID[i] != topID[4] && ID[i] != topID[5] && ID[i] != topID[6] && ID[i] != topID[7] && ID[i] != topID[8]
			&& ID[i] != topID[9] && ID[i] != topID[10] && ID[i] != topID[11] && ID[i] != topID[12] && ID[i] != topID[13] && ID[i] != topID[14] && ID[i] != topID[15] )
			{
			topID[16] = ID[i];
			topScore[16] = Score[i];
			topDeaths[16] = Deaths[i];
			topGames[16] = Games[i];
			topName[16] = Name[i];
			topCaps[16] = Caps[i];
			topCarrierKills[16] = CarrierKills[i];
			topGrabs[16] = Grabs[i];
			}
		}
	//#18
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[17] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] && ID[i] != topID[4] && ID[i] != topID[5] && ID[i] != topID[6] && ID[i] != topID[7] && ID[i] != topID[8]
			&& ID[i] != topID[9] && ID[i] != topID[10] && ID[i] != topID[11] && ID[i] != topID[12] && ID[i] != topID[13] && ID[i] != topID[14] && ID[i] != topID[15] && ID[i] != topID[16] )
			{
			topID[17] = ID[i];
			topScore[17] = Score[i];
			topDeaths[17] = Deaths[i];
			topGames[17] = Games[i];
			topName[17] = Name[i];
			topCaps[17] = Caps[i];
			topCarrierKills[17] = CarrierKills[i];
			topGrabs[17] = Grabs[i];
			}
		}
	//#19
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[18] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] && ID[i] != topID[4] && ID[i] != topID[5] && ID[i] != topID[6] && ID[i] != topID[7] && ID[i] != topID[8]
			&& ID[i] != topID[9] && ID[i] != topID[10] && ID[i] != topID[11] && ID[i] != topID[12] && ID[i] != topID[13] && ID[i] != topID[14] && ID[i] != topID[15] && ID[i] != topID[16] && ID[i] != topID[17] )
			{
			topID[18] = ID[i];
			topScore[18] = Score[i];
			topDeaths[18] = Deaths[i];
			topGames[18] = Games[i];
			topName[18] = Name[i];
			topCaps[18] = Caps[i];
			topCarrierKills[18] = CarrierKills[i];
			topGrabs[18] = Grabs[i];
			}
		}
	//#20
	for (i=0;i<10000;i++)
		{
		if ( Score[i] > topScore[19] && ID[i] != topID[0] && ID[i] != topID[1] && ID[i] != topID[2] && ID[i] != topID[3] && ID[i] != topID[4] && ID[i] != topID[5] && ID[i] != topID[6] && ID[i] != topID[7] && ID[i] != topID[8]
			&& ID[i] != topID[9] && ID[i] != topID[10] && ID[i] != topID[11] && ID[i] != topID[12] && ID[i] != topID[13] && ID[i] != topID[14] && ID[i] != topID[15] && ID[i] != topID[16] && ID[i] != topID[17] && ID[i] != topID[18] )
			{
			topID[19] = ID[i];
			topScore[19] = Score[i];
			topDeaths[19] = Deaths[i];
			topGames[19] = Games[i];
			topName[19] = Name[i];
			topCaps[19] = Caps[i];
			topCarrierKills[19] = CarrierKills[i];
			topGrabs[19] = Grabs[i];
			}
		}
}

defaultproperties
{
bAlreadyUpdated=False
}
